class MapLink
  attr_reader :destination_name, :collision_rect
  attr_reader :destination_coordinates

  # link_info should be Tiled::MapObject
  def initialize(args, link_info)
    if link_info.class == Tiled::MapObject
      __xml_init__(args, link_info)
    else
      __runtime_init__(args, link_info)
    end
  end

  def collision_rect
    @rect
  end

  def serialize
    {
      destination_coordinates: @destination_coordinates,
      destination_name: @destination_name
    }
  end

  def to_h
    serialize.to_s
  end

  def to_s
    serialize.to_s
  end

  #use when loading link info from storage
  def __xml_init__(args, link_info)
    attributes = link_info.attributes
    properties = link_info.properties

    @rect = {
      x: attributes.x.to_i,
      y: attributes.y.to_i,
      w: attributes.width.to_i,
      h: attributes.height.to_i,
    }

    @destination_name = properties.whereto

    @destination_coordinates = {
      x: properties.roomx,
      y: properties.roomy
    }

    @link_spawn_name = properties.linkspawn if properties.respond_to?(:linkspawn)
    if properties.respond_to?(:test)
      puts properties.test

      if properties.test_type == "object"
        puts properties.test.object
      end
    end
  end

  #use when creating link during runtime
  def __runtime_init__(args, link_info)

  end
end